#version 330
#extension GL_EXT_gpu_shader4 : enable
// Animated truchetMod01.fsh by  adroitwhiz

//https://www.shadertoy.com/view/tsVXDz
// Licence CC0
// Adapted, trivialy, for use in VGHD player
/////////////////////////////////////////////
uniform float u_Elapsed;    // The elapsed time in seconds
uniform vec2  u_WindowSize; // Window dimensions in pixels

#define iTime u_Elapsed*0.314159  //*0.1666
#define iResolution u_WindowSize

//#define mouse AUTO_MOUSE
//#define MOUSE_SPEED vec2(vec2(0.5,0.577777) * 0.25)
//#define MOUSE_POS   vec2((1.0+cos(iTime*MOUSE_SPEED))*u_WindowSize/2.0)
//#define MOUSE_PRESS vec2(0.0,0.0)
//#define AUTO_MOUSE  vec4( MOUSE_POS, MOUSE_PRESS )
//#define RIGID_SCROLL
// alternatively use static mouse definition
#define iMouse vec4(0.0,0.0, 0.0,0.0)
//#define iMouse vec4(512,256,180,120)
uniform sampler2D iChannel0;
uniform sampler2D iChannel1;
uniform sampler2D iChannel2;
uniform sampler2D iChannel3;
vec4 texture2D_Fract(sampler2D sampler,vec2 P) {return texture2D(sampler,fract(P));}
vec4 texture2D_Fract(sampler2D sampler,vec2 P, float Bias) {return texture2D(sampler,fract(P),Bias);}
#define texture2D texture2D_Fract

float rand(vec2 co){
    return fract(sin(dot(co.xy ,vec2(12.9898,78.233))) * 43758.5453);
}

float lineFromDistance(float dist, float size) {
    const float thickness = 2.0;
	return clamp((abs(dist - 0.5) * size) - (thickness - 1.0), 0.0, 1.0);
}

float sdBox( in vec2 p, in vec2 b )
{
    vec2 d = abs(p)-b;
    return length(max(d,vec2(0))) + min(max(d.x,d.y),0.0);
}
void main (void)
//void mainImage( out vec4 fragColor, in vec2 fragCoord )
{
    const float size = 25.0;
    const float period = 2.0;
    
    //vec2 coord = gl_FragCoord.xy + vec2(0.0, iTime * -10.0);
    vec2 coord = gl_FragCoord.xy;

    vec2 pixCoord = floor(coord / size) * size;
    
    float time = iTime * (rand(pixCoord) + 0.5) * 0.5;
    
    float blend = abs((mod(time, period) / period) - 0.5) * 2.0;
    
    float rand1 = rand(pixCoord + floor(time / period)) > 0.5 ? 1.0 : 0.0;
    float rand2 = rand(pixCoord + floor(((time + 99.9) + period * 0.5) / period)) > 0.5 ? 1.0 : 0.0;
    
    float randVal = mix(rand1, rand2, smoothstep(0.25, 0.75, blend));
    
    vec2 modcoord = mod(coord, size) / size;
    
    if (randVal > 0.5) {
    	modcoord.x = 1.0 - modcoord.x;
    }
    
    float boxMix = 1.0 - (abs(randVal - 0.5) * 2.0);
    
    float box1 = lineFromDistance(sdBox(modcoord, vec2(boxMix * 0.5)) + (boxMix * 0.5), size);
    float box2 = lineFromDistance(sdBox(1.0 - modcoord, vec2(boxMix * 0.5)) + (boxMix * 0.5), size);
    
    vec3 outcolor = vec3(box1 * box2);

    // Output to screen
    gl_FragColor = vec4(outcolor, 1.0);
}